package main

import (
	"storage_go/models"
	"strings"
)

const (
	limit = 10000
)

func main() {
	models.InitDb()
	LoopFunc(clients)
	//LoopFunc(logPost)
	//logPost()
	//access()
}

func clients(){
	maxId := models.GetMaxIdParseIp()
	clients := models.GetClientsIdIp(maxId, limit)

	for _, c := range clients {
		hosts := models.ParseIpPrepareData(strings.TrimSpace(c.Ip))
		if len(hosts) > 0 {
			models.ParseIpSaveData(hosts, c.Id)
		}
	}
}

//func access() {
//	maxId := models.GetMaxIdParseIp(typeAccess)
//	access := models.GetAccessIdLink(maxId)
//
//	for _, a := range access {
//		uri, err := url.Parse(strings.TrimSpace(a.Data))
//		if err != nil {
//			log.Fatalln(err)
//		}
//
//		models.ParseIpSaveData(uri, a.Id, typeAccess)
//	}
//}

//func logPost() {
//	maxId := models.GetMaxIdParseIp(typeLogPost)
//	logPosts := models.GetLogpostIdLink(maxId, limit)
//
//	if len(logPosts) > 0{
//		for _, l := range logPosts {
//			models.ParseIpPrepareData(l.Link)
//			models.ParseIpSaveData(l.Link, l.Id, typeLogPost)
//		}
//	}else{
//		time.Sleep(10 * time.Second)
//	}
//}